<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrainingRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'title',
        'description',
        'training_date',
        'vendor',
        'cost',
        'purposes',
        'expected_result',
        'status',
        'hrd_notes',
        'approved_by_hrd',
        'approved_at_hrd',
        'approved_by_director',
        'approved_at_director',
    ];

    protected $casts = [
        'training_date'        => 'date',
        'cost'                 => 'integer',
        'purposes'             => 'array',   // supaya otomatis jadi array di PHP
        'approved_at_hrd'      => 'datetime',
        'approved_at_director' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
